package xmldoc.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import com.gsl.io.core.stream.Streamable;
import com.gsl.logging.LoggerFactory;

/**
 * Builder of an {@code EntityResolutionMap}.
 * 
 * @author rhys
 */

public class EntityResolutionMapBuilder {

    protected final Map<String, String> uriToLocationMap = new HashMap<String, String>();

    protected final Map<String, Streamable> uriToNamedInputStreamMap = new HashMap<String, Streamable>();

    final private Logger logger = LoggerFactory.getLogger("EntityResolutionMapBuilder");

    public void add(final String[][] uriToLocationTable) {
        for (final String[] row : uriToLocationTable) {
            add(row[0], row[1]);
        }
    }

    public void add(final String uri, final String filepath) {
        if (!uri.trim().equals("")) {
            if (uriToLocationMap.containsKey(uri)) {
                logger.severe("Namespace '" + uri + "' is already mapped to file " + uriToLocationMap.get(uri)
                        + ", attempting to remap to " + filepath);
            }
            uriToLocationMap.put(uri, filepath);
        }
    }

    public void add(final String uri, final Streamable schema) {
        if (!uri.trim().equals("")) {
            if (uriToNamedInputStreamMap.containsKey(uri)) {
                logger.severe("Namespace '" + uri + "' is already mapped to a schema");
            }
            uriToNamedInputStreamMap.put(uri, schema);
        }
    }

    public EntityResolutionMap makeEntityResolutionMap() {
        return new EntityResolutionMap(uriToLocationMap, uriToNamedInputStreamMap);
    }
}
