package xmldoc.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileSystemEntityResolver extends AbstractEntityResolver {

    public FileSystemEntityResolver(final EntityResolutionMap entityResolutionMap) {
        super(entityResolutionMap);
    }

    public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException {
        InputSource resolvedInputSource = null;
        final String entityLocation = entityResolutionMap.getLocationFor(systemId);

        if (entityLocation != null) {
            try {
                final InputStream stream = new FileInputStream(entityLocation);
                resolvedInputSource = new InputSource(stream);
            } catch (final IOException e) {
                getLogger().log(Level.SEVERE, "Could not load schema file " + entityLocation + " for namespace " + systemId, e);
                throw new SAXException("Could not load schema file " + entityLocation + " for namespace " + systemId, e);
            }
        }

        return resolvedInputSource;
    }
}
